/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class GolombLongCodec
extends AbstractBitCodec<Long> {
    private int m;
    private boolean quotientBit = true;
    private long offset = 0L;

    public GolombLongCodec(long offset, int m) {
        if (m < 2) {
            throw new IllegalArgumentException("M parameter must be at least 2.");
        }
        this.m = m;
        this.quotientBit = true;
        this.offset = offset;
    }

    @Override
    public final Long read(BitInputStream bitInputStream) throws IOException {
        long quotient = 0L;
        while (bitInputStream.readBit() == this.quotientBit) {
            ++quotient;
        }
        long ceiling = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long reminder = bitInputStream.readBits((int)(ceiling - 1L));
        if ((double)reminder >= Math.pow(2.0, ceiling) - (double)this.m) {
            reminder <<= 1;
            reminder |= (long)bitInputStream.readBits(1);
            reminder = (long)((double)reminder - (Math.pow(2.0, ceiling) - (double)this.m));
        }
        return quotient * (long)this.m + reminder - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Long value) throws IOException {
        long newValue = value + this.offset;
        long quotient = newValue / (long)this.m;
        long reminder = newValue % (long)this.m;
        long ceiling = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long length = quotient + 1L;
        bitOutputStream.write(this.quotientBit, quotient);
        bitOutputStream.write(!this.quotientBit);
        if ((double)reminder < Math.pow(2.0, ceiling) - (double)this.m) {
            bitOutputStream.write(reminder, (int)ceiling - 1);
            length += ceiling - 1L;
        } else {
            bitOutputStream.write((int)((double)reminder + Math.pow(2.0, ceiling) - (double)this.m), (int)ceiling);
            length += ceiling;
        }
        return length;
    }

    @Override
    public final long numberOfBits(Long value) {
        long newValue = value + this.offset;
        long quotient = newValue / (long)this.m;
        long reminder = newValue % (long)this.m;
        long ceiling = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long l = quotient + 1L;
        l = (double)reminder < Math.pow(2.0, ceiling) - (double)this.m ? (l += ceiling - 1L) : (l += ceiling);
        return l;
    }

    @Override
    public Long read(BitInputStream bitInputStream, int length) throws IOException {
        throw new RuntimeException("Multi-value read method not defined.");
    }
}

