// GENERATED FILE - DO NOT EDIT.
// Generated by gen_spirv_builder_and_parser.py using data from spirv.core.grammar.json.
//
// Copyright 2021 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// spirv_instruction_parser_autogen.cpp:
//   Functions to parse SPIR-V binary for each instruction.

#include "spirv_instruction_parser_autogen.h"

#include <string.h>

#include "common/debug.h"

namespace angle
{
namespace spirv
{

void GetInstructionOpAndLength(const uint32_t *_instruction, spv::Op *opOut, uint32_t *lengthOut)
{
    constexpr uint32_t kOpMask = 0xFFFFu;
    *opOut                     = static_cast<spv::Op>(_instruction[0] & kOpMask);
    *lengthOut                 = _instruction[0] >> 16;
}
void ParseUndef(const uint32_t *_instruction, IdResultType *idResultType1, IdResult *idResult2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpUndef);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
}
void ParseSourceContinued(const uint32_t *_instruction, LiteralString *continuedSource)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSourceContinued);
    uint32_t _o = 1;
    ASSERT(IsLittleEndian());
    *continuedSource = reinterpret_cast<const char *>(&_instruction[_o]);
    _o += strlen(*continuedSource) / 4 + 1;
}
void ParseSource(const uint32_t *_instruction,
                 spv::SourceLanguage *sourceLanguage1,
                 LiteralInteger *version,
                 IdRef *file,
                 LiteralString *source)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSource);
    uint32_t _o      = 1;
    *sourceLanguage1 = spv::SourceLanguage(_instruction[_o++]);
    *version         = LiteralInteger(_instruction[_o++]);
    if (file && _o < _length)
    {
        *file = IdRef(_instruction[_o++]);
    }
    if (source && _o < _length)
    {
        ASSERT(IsLittleEndian());
        *source = reinterpret_cast<const char *>(&_instruction[_o]);
        _o += strlen(*source) / 4 + 1;
    }
}
void ParseSourceExtension(const uint32_t *_instruction, LiteralString *extension)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSourceExtension);
    uint32_t _o = 1;
    ASSERT(IsLittleEndian());
    *extension = reinterpret_cast<const char *>(&_instruction[_o]);
    _o += strlen(*extension) / 4 + 1;
}
void ParseName(const uint32_t *_instruction, IdRef *target, LiteralString *name)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpName);
    uint32_t _o = 1;
    *target     = IdRef(_instruction[_o++]);
    ASSERT(IsLittleEndian());
    *name = reinterpret_cast<const char *>(&_instruction[_o]);
    _o += strlen(*name) / 4 + 1;
}
void ParseMemberName(const uint32_t *_instruction,
                     IdRef *type,
                     LiteralInteger *member,
                     LiteralString *name)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpMemberName);
    uint32_t _o = 1;
    *type       = IdRef(_instruction[_o++]);
    *member     = LiteralInteger(_instruction[_o++]);
    ASSERT(IsLittleEndian());
    *name = reinterpret_cast<const char *>(&_instruction[_o]);
    _o += strlen(*name) / 4 + 1;
}
void ParseString(const uint32_t *_instruction, IdResult *idResult1, LiteralString *string)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpString);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
    ASSERT(IsLittleEndian());
    *string = reinterpret_cast<const char *>(&_instruction[_o]);
    _o += strlen(*string) / 4 + 1;
}
void ParseLine(const uint32_t *_instruction,
               IdRef *file,
               LiteralInteger *line,
               LiteralInteger *column)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpLine);
    uint32_t _o = 1;
    *file       = IdRef(_instruction[_o++]);
    *line       = LiteralInteger(_instruction[_o++]);
    *column     = LiteralInteger(_instruction[_o++]);
}
void ParseExtension(const uint32_t *_instruction, LiteralString *name)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpExtension);
    uint32_t _o = 1;
    ASSERT(IsLittleEndian());
    *name = reinterpret_cast<const char *>(&_instruction[_o]);
    _o += strlen(*name) / 4 + 1;
}
void ParseExtInstImport(const uint32_t *_instruction, IdResult *idResult1, LiteralString *name)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpExtInstImport);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
    ASSERT(IsLittleEndian());
    *name = reinterpret_cast<const char *>(&_instruction[_o]);
    _o += strlen(*name) / 4 + 1;
}
void ParseExtInst(const uint32_t *_instruction,
                  IdResultType *idResultType1,
                  IdResult *idResult2,
                  IdRef *set,
                  LiteralExtInstInteger *instruction,
                  IdRefList *operandList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpExtInst);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *set           = IdRef(_instruction[_o++]);
    *instruction   = LiteralExtInstInteger(_instruction[_o++]);
    if (operandList)
    {
        while (_o < _length)
        {
            operandList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseMemoryModel(const uint32_t *_instruction,
                      spv::AddressingModel *addressingModel1,
                      spv::MemoryModel *memoryModel2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpMemoryModel);
    uint32_t _o       = 1;
    *addressingModel1 = spv::AddressingModel(_instruction[_o++]);
    *memoryModel2     = spv::MemoryModel(_instruction[_o++]);
}
void ParseEntryPoint(const uint32_t *_instruction,
                     spv::ExecutionModel *executionModel1,
                     IdRef *entryPoint,
                     LiteralString *name,
                     IdRefList *interfaceList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpEntryPoint);
    uint32_t _o      = 1;
    *executionModel1 = spv::ExecutionModel(_instruction[_o++]);
    *entryPoint      = IdRef(_instruction[_o++]);
    ASSERT(IsLittleEndian());
    *name = reinterpret_cast<const char *>(&_instruction[_o]);
    _o += strlen(*name) / 4 + 1;
    if (interfaceList)
    {
        while (_o < _length)
        {
            interfaceList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseExecutionMode(const uint32_t *_instruction,
                        IdRef *entryPoint,
                        spv::ExecutionMode *mode,
                        LiteralIntegerList *operandsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpExecutionMode);
    uint32_t _o = 1;
    *entryPoint = IdRef(_instruction[_o++]);
    *mode       = spv::ExecutionMode(_instruction[_o++]);
    if (operandsList)
    {
        while (_o < _length)
        {
            operandsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseCapability(const uint32_t *_instruction, spv::Capability *capability)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpCapability);
    uint32_t _o = 1;
    *capability = spv::Capability(_instruction[_o++]);
}
void ParseTypeVoid(const uint32_t *_instruction, IdResult *idResult1)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeVoid);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
}
void ParseTypeBool(const uint32_t *_instruction, IdResult *idResult1)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeBool);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
}
void ParseTypeInt(const uint32_t *_instruction,
                  IdResult *idResult1,
                  LiteralInteger *width,
                  LiteralInteger *signedness)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeInt);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
    *width      = LiteralInteger(_instruction[_o++]);
    *signedness = LiteralInteger(_instruction[_o++]);
}
void ParseTypeFloat(const uint32_t *_instruction,
                    IdResult *idResult1,
                    LiteralInteger *width,
                    spv::FPEncoding *floatingPointEncoding)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeFloat);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
    *width      = LiteralInteger(_instruction[_o++]);
    if (floatingPointEncoding && _o < _length)
    {
        *floatingPointEncoding = spv::FPEncoding(_instruction[_o++]);
    }
}
void ParseTypeVector(const uint32_t *_instruction,
                     IdResult *idResult1,
                     IdRef *componentType,
                     LiteralInteger *componentCount)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeVector);
    uint32_t _o     = 1;
    *idResult1      = IdResult(_instruction[_o++]);
    *componentType  = IdRef(_instruction[_o++]);
    *componentCount = LiteralInteger(_instruction[_o++]);
}
void ParseTypeMatrix(const uint32_t *_instruction,
                     IdResult *idResult1,
                     IdRef *columnType,
                     LiteralInteger *columnCount)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeMatrix);
    uint32_t _o  = 1;
    *idResult1   = IdResult(_instruction[_o++]);
    *columnType  = IdRef(_instruction[_o++]);
    *columnCount = LiteralInteger(_instruction[_o++]);
}
void ParseTypeImage(const uint32_t *_instruction,
                    IdResult *idResult1,
                    IdRef *sampledType,
                    spv::Dim *dim3,
                    LiteralInteger *depth,
                    LiteralInteger *arrayed,
                    LiteralInteger *mS,
                    LiteralInteger *sampled,
                    spv::ImageFormat *imageFormat8,
                    spv::AccessQualifier *accessQualifier9)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeImage);
    uint32_t _o   = 1;
    *idResult1    = IdResult(_instruction[_o++]);
    *sampledType  = IdRef(_instruction[_o++]);
    *dim3         = spv::Dim(_instruction[_o++]);
    *depth        = LiteralInteger(_instruction[_o++]);
    *arrayed      = LiteralInteger(_instruction[_o++]);
    *mS           = LiteralInteger(_instruction[_o++]);
    *sampled      = LiteralInteger(_instruction[_o++]);
    *imageFormat8 = spv::ImageFormat(_instruction[_o++]);
    if (accessQualifier9 && _o < _length)
    {
        *accessQualifier9 = spv::AccessQualifier(_instruction[_o++]);
    }
}
void ParseTypeSampler(const uint32_t *_instruction, IdResult *idResult1)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeSampler);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
}
void ParseTypeSampledImage(const uint32_t *_instruction, IdResult *idResult1, IdRef *imageType)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeSampledImage);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
    *imageType  = IdRef(_instruction[_o++]);
}
void ParseTypeArray(const uint32_t *_instruction,
                    IdResult *idResult1,
                    IdRef *elementType,
                    IdRef *length)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeArray);
    uint32_t _o  = 1;
    *idResult1   = IdResult(_instruction[_o++]);
    *elementType = IdRef(_instruction[_o++]);
    *length      = IdRef(_instruction[_o++]);
}
void ParseTypeRuntimeArray(const uint32_t *_instruction, IdResult *idResult1, IdRef *elementType)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeRuntimeArray);
    uint32_t _o  = 1;
    *idResult1   = IdResult(_instruction[_o++]);
    *elementType = IdRef(_instruction[_o++]);
}
void ParseTypeStruct(const uint32_t *_instruction, IdResult *idResult1, IdRefList *memberList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeStruct);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
    if (memberList)
    {
        while (_o < _length)
        {
            memberList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseTypePointer(const uint32_t *_instruction,
                      IdResult *idResult1,
                      spv::StorageClass *storageClass2,
                      IdRef *type)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypePointer);
    uint32_t _o    = 1;
    *idResult1     = IdResult(_instruction[_o++]);
    *storageClass2 = spv::StorageClass(_instruction[_o++]);
    *type          = IdRef(_instruction[_o++]);
}
void ParseTypeFunction(const uint32_t *_instruction,
                       IdResult *idResult1,
                       IdRef *returnType,
                       IdRefList *parameterList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTypeFunction);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
    *returnType = IdRef(_instruction[_o++]);
    if (parameterList)
    {
        while (_o < _length)
        {
            parameterList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseConstantTrue(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpConstantTrue);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
}
void ParseConstantFalse(const uint32_t *_instruction,
                        IdResultType *idResultType1,
                        IdResult *idResult2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpConstantFalse);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
}
void ParseConstant(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   LiteralContextDependentNumber *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpConstant);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *value         = LiteralContextDependentNumber(_instruction[_o++]);
}
void ParseConstantComposite(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRefList *constituentsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpConstantComposite);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    if (constituentsList)
    {
        while (_o < _length)
        {
            constituentsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseConstantNull(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpConstantNull);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
}
void ParseSpecConstantTrue(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSpecConstantTrue);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
}
void ParseSpecConstantFalse(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSpecConstantFalse);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
}
void ParseSpecConstant(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       LiteralContextDependentNumber *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSpecConstant);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *value         = LiteralContextDependentNumber(_instruction[_o++]);
}
void ParseSpecConstantComposite(const uint32_t *_instruction,
                                IdResultType *idResultType1,
                                IdResult *idResult2,
                                IdRefList *constituentsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSpecConstantComposite);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    if (constituentsList)
    {
        while (_o < _length)
        {
            constituentsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseFunction(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   spv::FunctionControlMask *functionControl3,
                   IdRef *functionType)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFunction);
    uint32_t _o       = 1;
    *idResultType1    = IdResultType(_instruction[_o++]);
    *idResult2        = IdResult(_instruction[_o++]);
    *functionControl3 = spv::FunctionControlMask(_instruction[_o++]);
    *functionType     = IdRef(_instruction[_o++]);
}
void ParseFunctionParameter(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFunctionParameter);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
}
void ParseFunctionCall(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *function,
                       IdRefList *argumentList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFunctionCall);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *function      = IdRef(_instruction[_o++]);
    if (argumentList)
    {
        while (_o < _length)
        {
            argumentList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseVariable(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   spv::StorageClass *storageClass3,
                   IdRef *initializer)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpVariable);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *storageClass3 = spv::StorageClass(_instruction[_o++]);
    if (initializer && _o < _length)
    {
        *initializer = IdRef(_instruction[_o++]);
    }
}
void ParseImageTexelPointer(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *image,
                            IdRef *coordinate,
                            IdRef *sample)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageTexelPointer);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *image         = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    *sample        = IdRef(_instruction[_o++]);
}
void ParseLoad(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *pointer,
               spv::MemoryAccessMask *memoryAccess4)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpLoad);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    if (memoryAccess4 && _o < _length)
    {
        *memoryAccess4 = spv::MemoryAccessMask(_instruction[_o++]);
    }
}
void ParseStore(const uint32_t *_instruction,
                IdRef *pointer,
                IdRef *object,
                spv::MemoryAccessMask *memoryAccess3)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpStore);
    uint32_t _o = 1;
    *pointer    = IdRef(_instruction[_o++]);
    *object     = IdRef(_instruction[_o++]);
    if (memoryAccess3 && _o < _length)
    {
        *memoryAccess3 = spv::MemoryAccessMask(_instruction[_o++]);
    }
}
void ParseCopyMemory(const uint32_t *_instruction,
                     IdRef *target,
                     IdRef *source,
                     spv::MemoryAccessMask *memoryAccess3,
                     spv::MemoryAccessMask *memoryAccess4)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpCopyMemory);
    uint32_t _o = 1;
    *target     = IdRef(_instruction[_o++]);
    *source     = IdRef(_instruction[_o++]);
    if (memoryAccess3 && _o < _length)
    {
        *memoryAccess3 = spv::MemoryAccessMask(_instruction[_o++]);
    }
    if (memoryAccess4 && _o < _length)
    {
        *memoryAccess4 = spv::MemoryAccessMask(_instruction[_o++]);
    }
}
void ParseAccessChain(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *base,
                      IdRefList *indexesList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAccessChain);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *base          = IdRef(_instruction[_o++]);
    if (indexesList)
    {
        while (_o < _length)
        {
            indexesList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseInBoundsAccessChain(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdRef *base,
                              IdRefList *indexesList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpInBoundsAccessChain);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *base          = IdRef(_instruction[_o++]);
    if (indexesList)
    {
        while (_o < _length)
        {
            indexesList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseArrayLength(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *structure,
                      LiteralInteger *arraymember)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpArrayLength);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *structure     = IdRef(_instruction[_o++]);
    *arraymember   = LiteralInteger(_instruction[_o++]);
}
void ParseDecorate(const uint32_t *_instruction,
                   IdRef *target,
                   spv::Decoration *decoration2,
                   LiteralIntegerList *valuesList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpDecorate);
    uint32_t _o  = 1;
    *target      = IdRef(_instruction[_o++]);
    *decoration2 = spv::Decoration(_instruction[_o++]);
    if (valuesList)
    {
        while (_o < _length)
        {
            valuesList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseMemberDecorate(const uint32_t *_instruction,
                         IdRef *structureType,
                         LiteralInteger *member,
                         spv::Decoration *decoration3,
                         LiteralIntegerList *valuesList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpMemberDecorate);
    uint32_t _o    = 1;
    *structureType = IdRef(_instruction[_o++]);
    *member        = LiteralInteger(_instruction[_o++]);
    *decoration3   = spv::Decoration(_instruction[_o++]);
    if (valuesList)
    {
        while (_o < _length)
        {
            valuesList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseDecorationGroup(const uint32_t *_instruction, IdResult *idResult1)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpDecorationGroup);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
}
void ParseGroupDecorate(const uint32_t *_instruction,
                        IdRef *decorationGroup,
                        IdRefList *targetsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupDecorate);
    uint32_t _o      = 1;
    *decorationGroup = IdRef(_instruction[_o++]);
    if (targetsList)
    {
        while (_o < _length)
        {
            targetsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseGroupMemberDecorate(const uint32_t *_instruction,
                              IdRef *decorationGroup,
                              PairIdRefLiteralIntegerList *targetsPairList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupMemberDecorate);
    uint32_t _o      = 1;
    *decorationGroup = IdRef(_instruction[_o++]);
    if (targetsPairList)
    {
        while (_o < _length)
        {
            targetsPairList->emplace_back(PairIdRefLiteralInteger{
                IdRef(_instruction[_o]), LiteralInteger(_instruction[_o + 1])});
            _o += 2;
        }
    }
}
void ParseVectorExtractDynamic(const uint32_t *_instruction,
                               IdResultType *idResultType1,
                               IdResult *idResult2,
                               IdRef *vector,
                               IdRef *index)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpVectorExtractDynamic);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *vector        = IdRef(_instruction[_o++]);
    *index         = IdRef(_instruction[_o++]);
}
void ParseVectorInsertDynamic(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdRef *vector,
                              IdRef *component,
                              IdRef *index)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpVectorInsertDynamic);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *vector        = IdRef(_instruction[_o++]);
    *component     = IdRef(_instruction[_o++]);
    *index         = IdRef(_instruction[_o++]);
}
void ParseVectorShuffle(const uint32_t *_instruction,
                        IdResultType *idResultType1,
                        IdResult *idResult2,
                        IdRef *vector1,
                        IdRef *vector2,
                        LiteralIntegerList *componentsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpVectorShuffle);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *vector1       = IdRef(_instruction[_o++]);
    *vector2       = IdRef(_instruction[_o++]);
    if (componentsList)
    {
        while (_o < _length)
        {
            componentsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseCompositeConstruct(const uint32_t *_instruction,
                             IdResultType *idResultType1,
                             IdResult *idResult2,
                             IdRefList *constituentsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpCompositeConstruct);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    if (constituentsList)
    {
        while (_o < _length)
        {
            constituentsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseCompositeExtract(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *composite,
                           LiteralIntegerList *indexesList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpCompositeExtract);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *composite     = IdRef(_instruction[_o++]);
    if (indexesList)
    {
        while (_o < _length)
        {
            indexesList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseCompositeInsert(const uint32_t *_instruction,
                          IdResultType *idResultType1,
                          IdResult *idResult2,
                          IdRef *object,
                          IdRef *composite,
                          LiteralIntegerList *indexesList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpCompositeInsert);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *object        = IdRef(_instruction[_o++]);
    *composite     = IdRef(_instruction[_o++]);
    if (indexesList)
    {
        while (_o < _length)
        {
            indexesList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseCopyObject(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpCopyObject);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand       = IdRef(_instruction[_o++]);
}
void ParseTranspose(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *matrix)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpTranspose);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *matrix        = IdRef(_instruction[_o++]);
}
void ParseSampledImage(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *image,
                       IdRef *sampler)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSampledImage);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *image         = IdRef(_instruction[_o++]);
    *sampler       = IdRef(_instruction[_o++]);
}
void ParseImageSampleImplicitLod(const uint32_t *_instruction,
                                 IdResultType *idResultType1,
                                 IdResult *idResult2,
                                 IdRef *sampledImage,
                                 IdRef *coordinate,
                                 spv::ImageOperandsMask *imageOperands5,
                                 IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSampleImplicitLod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    if (imageOperands5 && _o < _length)
    {
        *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSampleExplicitLod(const uint32_t *_instruction,
                                 IdResultType *idResultType1,
                                 IdResult *idResult2,
                                 IdRef *sampledImage,
                                 IdRef *coordinate,
                                 spv::ImageOperandsMask *imageOperands5,
                                 IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSampleExplicitLod);
    uint32_t _o     = 1;
    *idResultType1  = IdResultType(_instruction[_o++]);
    *idResult2      = IdResult(_instruction[_o++]);
    *sampledImage   = IdRef(_instruction[_o++]);
    *coordinate     = IdRef(_instruction[_o++]);
    *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSampleDrefImplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType1,
                                     IdResult *idResult2,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     IdRef *dref,
                                     spv::ImageOperandsMask *imageOperands6,
                                     IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSampleDrefImplicitLod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    *dref          = IdRef(_instruction[_o++]);
    if (imageOperands6 && _o < _length)
    {
        *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSampleDrefExplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType1,
                                     IdResult *idResult2,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     IdRef *dref,
                                     spv::ImageOperandsMask *imageOperands6,
                                     IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSampleDrefExplicitLod);
    uint32_t _o     = 1;
    *idResultType1  = IdResultType(_instruction[_o++]);
    *idResult2      = IdResult(_instruction[_o++]);
    *sampledImage   = IdRef(_instruction[_o++]);
    *coordinate     = IdRef(_instruction[_o++]);
    *dref           = IdRef(_instruction[_o++]);
    *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSampleProjImplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType1,
                                     IdResult *idResult2,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     spv::ImageOperandsMask *imageOperands5,
                                     IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSampleProjImplicitLod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    if (imageOperands5 && _o < _length)
    {
        *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSampleProjExplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType1,
                                     IdResult *idResult2,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     spv::ImageOperandsMask *imageOperands5,
                                     IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSampleProjExplicitLod);
    uint32_t _o     = 1;
    *idResultType1  = IdResultType(_instruction[_o++]);
    *idResult2      = IdResult(_instruction[_o++]);
    *sampledImage   = IdRef(_instruction[_o++]);
    *coordinate     = IdRef(_instruction[_o++]);
    *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSampleProjDrefImplicitLod(const uint32_t *_instruction,
                                         IdResultType *idResultType1,
                                         IdResult *idResult2,
                                         IdRef *sampledImage,
                                         IdRef *coordinate,
                                         IdRef *dref,
                                         spv::ImageOperandsMask *imageOperands6,
                                         IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSampleProjDrefImplicitLod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    *dref          = IdRef(_instruction[_o++]);
    if (imageOperands6 && _o < _length)
    {
        *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSampleProjDrefExplicitLod(const uint32_t *_instruction,
                                         IdResultType *idResultType1,
                                         IdResult *idResult2,
                                         IdRef *sampledImage,
                                         IdRef *coordinate,
                                         IdRef *dref,
                                         spv::ImageOperandsMask *imageOperands6,
                                         IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSampleProjDrefExplicitLod);
    uint32_t _o     = 1;
    *idResultType1  = IdResultType(_instruction[_o++]);
    *idResult2      = IdResult(_instruction[_o++]);
    *sampledImage   = IdRef(_instruction[_o++]);
    *coordinate     = IdRef(_instruction[_o++]);
    *dref           = IdRef(_instruction[_o++]);
    *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageFetch(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *image,
                     IdRef *coordinate,
                     spv::ImageOperandsMask *imageOperands5,
                     IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageFetch);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *image         = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    if (imageOperands5 && _o < _length)
    {
        *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageGather(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *sampledImage,
                      IdRef *coordinate,
                      IdRef *component,
                      spv::ImageOperandsMask *imageOperands6,
                      IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageGather);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    *component     = IdRef(_instruction[_o++]);
    if (imageOperands6 && _o < _length)
    {
        *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageDrefGather(const uint32_t *_instruction,
                          IdResultType *idResultType1,
                          IdResult *idResult2,
                          IdRef *sampledImage,
                          IdRef *coordinate,
                          IdRef *dref,
                          spv::ImageOperandsMask *imageOperands6,
                          IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageDrefGather);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    *dref          = IdRef(_instruction[_o++]);
    if (imageOperands6 && _o < _length)
    {
        *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageRead(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *image,
                    IdRef *coordinate,
                    spv::ImageOperandsMask *imageOperands5,
                    IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageRead);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *image         = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    if (imageOperands5 && _o < _length)
    {
        *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageWrite(const uint32_t *_instruction,
                     IdRef *image,
                     IdRef *coordinate,
                     IdRef *texel,
                     spv::ImageOperandsMask *imageOperands4,
                     IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageWrite);
    uint32_t _o = 1;
    *image      = IdRef(_instruction[_o++]);
    *coordinate = IdRef(_instruction[_o++]);
    *texel      = IdRef(_instruction[_o++]);
    if (imageOperands4 && _o < _length)
    {
        *imageOperands4 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImage(const uint32_t *_instruction,
                IdResultType *idResultType1,
                IdResult *idResult2,
                IdRef *sampledImage)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImage);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
}
void ParseImageQuerySizeLod(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *image,
                            IdRef *levelofDetail)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageQuerySizeLod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *image         = IdRef(_instruction[_o++]);
    *levelofDetail = IdRef(_instruction[_o++]);
}
void ParseImageQuerySize(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *image)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageQuerySize);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *image         = IdRef(_instruction[_o++]);
}
void ParseImageQueryLod(const uint32_t *_instruction,
                        IdResultType *idResultType1,
                        IdResult *idResult2,
                        IdRef *sampledImage,
                        IdRef *coordinate)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageQueryLod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
}
void ParseImageQueryLevels(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *image)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageQueryLevels);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *image         = IdRef(_instruction[_o++]);
}
void ParseImageQuerySamples(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *image)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageQuerySamples);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *image         = IdRef(_instruction[_o++]);
}
void ParseConvertFToU(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *floatValue)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpConvertFToU);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *floatValue    = IdRef(_instruction[_o++]);
}
void ParseConvertFToS(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *floatValue)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpConvertFToS);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *floatValue    = IdRef(_instruction[_o++]);
}
void ParseConvertSToF(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *signedValue)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpConvertSToF);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *signedValue   = IdRef(_instruction[_o++]);
}
void ParseConvertUToF(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *unsignedValue)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpConvertUToF);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *unsignedValue = IdRef(_instruction[_o++]);
}
void ParseUConvert(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *unsignedValue)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpUConvert);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *unsignedValue = IdRef(_instruction[_o++]);
}
void ParseSConvert(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *signedValue)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSConvert);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *signedValue   = IdRef(_instruction[_o++]);
}
void ParseFConvert(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *floatValue)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFConvert);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *floatValue    = IdRef(_instruction[_o++]);
}
void ParseQuantizeToF16(const uint32_t *_instruction,
                        IdResultType *idResultType1,
                        IdResult *idResult2,
                        IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpQuantizeToF16);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseBitcast(const uint32_t *_instruction,
                  IdResultType *idResultType1,
                  IdResult *idResult2,
                  IdRef *operand)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpBitcast);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand       = IdRef(_instruction[_o++]);
}
void ParseSNegate(const uint32_t *_instruction,
                  IdResultType *idResultType1,
                  IdResult *idResult2,
                  IdRef *operand)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSNegate);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand       = IdRef(_instruction[_o++]);
}
void ParseFNegate(const uint32_t *_instruction,
                  IdResultType *idResultType1,
                  IdResult *idResult2,
                  IdRef *operand)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFNegate);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand       = IdRef(_instruction[_o++]);
}
void ParseIAdd(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpIAdd);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFAdd(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFAdd);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseISub(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpISub);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFSub(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFSub);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseIMul(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpIMul);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFMul(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFMul);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseUDiv(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpUDiv);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseSDiv(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSDiv);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFDiv(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFDiv);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseUMod(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpUMod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseSRem(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSRem);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseSMod(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSMod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFRem(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFRem);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFMod(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *operand1,
               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFMod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseVectorTimesScalar(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *vector,
                            IdRef *scalar)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpVectorTimesScalar);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *vector        = IdRef(_instruction[_o++]);
    *scalar        = IdRef(_instruction[_o++]);
}
void ParseMatrixTimesScalar(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *matrix,
                            IdRef *scalar)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpMatrixTimesScalar);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *matrix        = IdRef(_instruction[_o++]);
    *scalar        = IdRef(_instruction[_o++]);
}
void ParseVectorTimesMatrix(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *vector,
                            IdRef *matrix)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpVectorTimesMatrix);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *vector        = IdRef(_instruction[_o++]);
    *matrix        = IdRef(_instruction[_o++]);
}
void ParseMatrixTimesVector(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *matrix,
                            IdRef *vector)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpMatrixTimesVector);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *matrix        = IdRef(_instruction[_o++]);
    *vector        = IdRef(_instruction[_o++]);
}
void ParseMatrixTimesMatrix(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *leftMatrix,
                            IdRef *rightMatrix)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpMatrixTimesMatrix);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *leftMatrix    = IdRef(_instruction[_o++]);
    *rightMatrix   = IdRef(_instruction[_o++]);
}
void ParseOuterProduct(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *vector1,
                       IdRef *vector2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpOuterProduct);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *vector1       = IdRef(_instruction[_o++]);
    *vector2       = IdRef(_instruction[_o++]);
}
void ParseDot(const uint32_t *_instruction,
              IdResultType *idResultType1,
              IdResult *idResult2,
              IdRef *vector1,
              IdRef *vector2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpDot);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *vector1       = IdRef(_instruction[_o++]);
    *vector2       = IdRef(_instruction[_o++]);
}
void ParseIAddCarry(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpIAddCarry);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseISubBorrow(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand1,
                     IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpISubBorrow);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseUMulExtended(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpUMulExtended);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseSMulExtended(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSMulExtended);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseAny(const uint32_t *_instruction,
              IdResultType *idResultType1,
              IdResult *idResult2,
              IdRef *vector)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAny);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *vector        = IdRef(_instruction[_o++]);
}
void ParseAll(const uint32_t *_instruction,
              IdResultType *idResultType1,
              IdResult *idResult2,
              IdRef *vector)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAll);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *vector        = IdRef(_instruction[_o++]);
}
void ParseIsNan(const uint32_t *_instruction,
                IdResultType *idResultType1,
                IdResult *idResult2,
                IdRef *x)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpIsNan);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *x             = IdRef(_instruction[_o++]);
}
void ParseIsInf(const uint32_t *_instruction,
                IdResultType *idResultType1,
                IdResult *idResult2,
                IdRef *x)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpIsInf);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *x             = IdRef(_instruction[_o++]);
}
void ParseLogicalEqual(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpLogicalEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseLogicalNotEqual(const uint32_t *_instruction,
                          IdResultType *idResultType1,
                          IdResult *idResult2,
                          IdRef *operand1,
                          IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpLogicalNotEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseLogicalOr(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpLogicalOr);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseLogicalAnd(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand1,
                     IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpLogicalAnd);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseLogicalNot(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpLogicalNot);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand       = IdRef(_instruction[_o++]);
}
void ParseSelect(const uint32_t *_instruction,
                 IdResultType *idResultType1,
                 IdResult *idResult2,
                 IdRef *condition,
                 IdRef *object1,
                 IdRef *object2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSelect);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *condition     = IdRef(_instruction[_o++]);
    *object1       = IdRef(_instruction[_o++]);
    *object2       = IdRef(_instruction[_o++]);
}
void ParseIEqual(const uint32_t *_instruction,
                 IdResultType *idResultType1,
                 IdResult *idResult2,
                 IdRef *operand1,
                 IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpIEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseINotEqual(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpINotEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseUGreaterThan(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpUGreaterThan);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseSGreaterThan(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSGreaterThan);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseUGreaterThanEqual(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *operand1,
                            IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpUGreaterThanEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseSGreaterThanEqual(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *operand1,
                            IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSGreaterThanEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseULessThan(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpULessThan);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseSLessThan(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSLessThan);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseULessThanEqual(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *operand1,
                         IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpULessThanEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseSLessThanEqual(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *operand1,
                         IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSLessThanEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFOrdEqual(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFOrdEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFUnordEqual(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *operand1,
                      IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFUnordEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFOrdNotEqual(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFOrdNotEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFUnordNotEqual(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *operand1,
                         IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFUnordNotEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFOrdLessThan(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *operand1,
                       IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFOrdLessThan);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFUnordLessThan(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *operand1,
                         IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFUnordLessThan);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFOrdGreaterThan(const uint32_t *_instruction,
                          IdResultType *idResultType1,
                          IdResult *idResult2,
                          IdRef *operand1,
                          IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFOrdGreaterThan);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFUnordGreaterThan(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *operand1,
                            IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFUnordGreaterThan);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFOrdLessThanEqual(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *operand1,
                            IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFOrdLessThanEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFUnordLessThanEqual(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdRef *operand1,
                              IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFUnordLessThanEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFOrdGreaterThanEqual(const uint32_t *_instruction,
                               IdResultType *idResultType1,
                               IdResult *idResult2,
                               IdRef *operand1,
                               IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFOrdGreaterThanEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseFUnordGreaterThanEqual(const uint32_t *_instruction,
                                 IdResultType *idResultType1,
                                 IdResult *idResult2,
                                 IdRef *operand1,
                                 IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFUnordGreaterThanEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseShiftRightLogical(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *base,
                            IdRef *shift)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpShiftRightLogical);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *base          = IdRef(_instruction[_o++]);
    *shift         = IdRef(_instruction[_o++]);
}
void ParseShiftRightArithmetic(const uint32_t *_instruction,
                               IdResultType *idResultType1,
                               IdResult *idResult2,
                               IdRef *base,
                               IdRef *shift)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpShiftRightArithmetic);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *base          = IdRef(_instruction[_o++]);
    *shift         = IdRef(_instruction[_o++]);
}
void ParseShiftLeftLogical(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *base,
                           IdRef *shift)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpShiftLeftLogical);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *base          = IdRef(_instruction[_o++]);
    *shift         = IdRef(_instruction[_o++]);
}
void ParseBitwiseOr(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *operand1,
                    IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpBitwiseOr);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseBitwiseXor(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand1,
                     IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpBitwiseXor);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseBitwiseAnd(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *operand1,
                     IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpBitwiseAnd);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParseNot(const uint32_t *_instruction,
              IdResultType *idResultType1,
              IdResult *idResult2,
              IdRef *operand)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpNot);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand       = IdRef(_instruction[_o++]);
}
void ParseBitFieldInsert(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *base,
                         IdRef *insert,
                         IdRef *offset,
                         IdRef *count)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpBitFieldInsert);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *base          = IdRef(_instruction[_o++]);
    *insert        = IdRef(_instruction[_o++]);
    *offset        = IdRef(_instruction[_o++]);
    *count         = IdRef(_instruction[_o++]);
}
void ParseBitFieldSExtract(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *base,
                           IdRef *offset,
                           IdRef *count)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpBitFieldSExtract);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *base          = IdRef(_instruction[_o++]);
    *offset        = IdRef(_instruction[_o++]);
    *count         = IdRef(_instruction[_o++]);
}
void ParseBitFieldUExtract(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *base,
                           IdRef *offset,
                           IdRef *count)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpBitFieldUExtract);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *base          = IdRef(_instruction[_o++]);
    *offset        = IdRef(_instruction[_o++]);
    *count         = IdRef(_instruction[_o++]);
}
void ParseBitReverse(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *base)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpBitReverse);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *base          = IdRef(_instruction[_o++]);
}
void ParseBitCount(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *base)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpBitCount);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *base          = IdRef(_instruction[_o++]);
}
void ParseDPdx(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *p)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpDPdx);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *p             = IdRef(_instruction[_o++]);
}
void ParseDPdy(const uint32_t *_instruction,
               IdResultType *idResultType1,
               IdResult *idResult2,
               IdRef *p)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpDPdy);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *p             = IdRef(_instruction[_o++]);
}
void ParseFwidth(const uint32_t *_instruction,
                 IdResultType *idResultType1,
                 IdResult *idResult2,
                 IdRef *p)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFwidth);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *p             = IdRef(_instruction[_o++]);
}
void ParseDPdxFine(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *p)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpDPdxFine);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *p             = IdRef(_instruction[_o++]);
}
void ParseDPdyFine(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *p)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpDPdyFine);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *p             = IdRef(_instruction[_o++]);
}
void ParseFwidthFine(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *p)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFwidthFine);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *p             = IdRef(_instruction[_o++]);
}
void ParseDPdxCoarse(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *p)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpDPdxCoarse);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *p             = IdRef(_instruction[_o++]);
}
void ParseDPdyCoarse(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *p)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpDPdyCoarse);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *p             = IdRef(_instruction[_o++]);
}
void ParseFwidthCoarse(const uint32_t *_instruction,
                       IdResultType *idResultType1,
                       IdResult *idResult2,
                       IdRef *p)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpFwidthCoarse);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *p             = IdRef(_instruction[_o++]);
}
void ParseEmitStreamVertex(const uint32_t *_instruction, IdRef *stream)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpEmitStreamVertex);
    uint32_t _o = 1;
    *stream     = IdRef(_instruction[_o++]);
}
void ParseEndStreamPrimitive(const uint32_t *_instruction, IdRef *stream)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpEndStreamPrimitive);
    uint32_t _o = 1;
    *stream     = IdRef(_instruction[_o++]);
}
void ParseControlBarrier(const uint32_t *_instruction,
                         IdScope *execution,
                         IdScope *memory,
                         IdMemorySemantics *semantics)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpControlBarrier);
    uint32_t _o = 1;
    *execution  = IdScope(_instruction[_o++]);
    *memory     = IdScope(_instruction[_o++]);
    *semantics  = IdMemorySemantics(_instruction[_o++]);
}
void ParseMemoryBarrier(const uint32_t *_instruction, IdScope *memory, IdMemorySemantics *semantics)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpMemoryBarrier);
    uint32_t _o = 1;
    *memory     = IdScope(_instruction[_o++]);
    *semantics  = IdMemorySemantics(_instruction[_o++]);
}
void ParseAtomicLoad(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicLoad);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
}
void ParseAtomicStore(const uint32_t *_instruction,
                      IdRef *pointer,
                      IdScope *memory,
                      IdMemorySemantics *semantics,
                      IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicStore);
    uint32_t _o = 1;
    *pointer    = IdRef(_instruction[_o++]);
    *memory     = IdScope(_instruction[_o++]);
    *semantics  = IdMemorySemantics(_instruction[_o++]);
    *value      = IdRef(_instruction[_o++]);
}
void ParseAtomicExchange(const uint32_t *_instruction,
                         IdResultType *idResultType1,
                         IdResult *idResult2,
                         IdRef *pointer,
                         IdScope *memory,
                         IdMemorySemantics *semantics,
                         IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicExchange);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseAtomicCompareExchange(const uint32_t *_instruction,
                                IdResultType *idResultType1,
                                IdResult *idResult2,
                                IdRef *pointer,
                                IdScope *memory,
                                IdMemorySemantics *equal,
                                IdMemorySemantics *unequal,
                                IdRef *value,
                                IdRef *comparator)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicCompareExchange);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *equal         = IdMemorySemantics(_instruction[_o++]);
    *unequal       = IdMemorySemantics(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    *comparator    = IdRef(_instruction[_o++]);
}
void ParseAtomicIIncrement(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *pointer,
                           IdScope *memory,
                           IdMemorySemantics *semantics)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicIIncrement);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
}
void ParseAtomicIDecrement(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *pointer,
                           IdScope *memory,
                           IdMemorySemantics *semantics)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicIDecrement);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
}
void ParseAtomicIAdd(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicIAdd);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseAtomicISub(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicISub);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseAtomicSMin(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicSMin);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseAtomicUMin(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicUMin);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseAtomicSMax(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicSMax);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseAtomicUMax(const uint32_t *_instruction,
                     IdResultType *idResultType1,
                     IdResult *idResult2,
                     IdRef *pointer,
                     IdScope *memory,
                     IdMemorySemantics *semantics,
                     IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicUMax);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseAtomicAnd(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *pointer,
                    IdScope *memory,
                    IdMemorySemantics *semantics,
                    IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicAnd);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseAtomicOr(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *pointer,
                   IdScope *memory,
                   IdMemorySemantics *semantics,
                   IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicOr);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseAtomicXor(const uint32_t *_instruction,
                    IdResultType *idResultType1,
                    IdResult *idResult2,
                    IdRef *pointer,
                    IdScope *memory,
                    IdMemorySemantics *semantics,
                    IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpAtomicXor);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *pointer       = IdRef(_instruction[_o++]);
    *memory        = IdScope(_instruction[_o++]);
    *semantics     = IdMemorySemantics(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParsePhi(const uint32_t *_instruction,
              IdResultType *idResultType1,
              IdResult *idResult2,
              PairIdRefIdRefList *variableParentPairList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpPhi);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    if (variableParentPairList)
    {
        while (_o < _length)
        {
            variableParentPairList->emplace_back(
                PairIdRefIdRef{IdRef(_instruction[_o]), IdRef(_instruction[_o + 1])});
            _o += 2;
        }
    }
}
void ParseLoopMerge(const uint32_t *_instruction,
                    IdRef *mergeBlock,
                    IdRef *continueTarget,
                    spv::LoopControlMask *loopControl3)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpLoopMerge);
    uint32_t _o     = 1;
    *mergeBlock     = IdRef(_instruction[_o++]);
    *continueTarget = IdRef(_instruction[_o++]);
    *loopControl3   = spv::LoopControlMask(_instruction[_o++]);
}
void ParseSelectionMerge(const uint32_t *_instruction,
                         IdRef *mergeBlock,
                         spv::SelectionControlMask *selectionControl2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSelectionMerge);
    uint32_t _o        = 1;
    *mergeBlock        = IdRef(_instruction[_o++]);
    *selectionControl2 = spv::SelectionControlMask(_instruction[_o++]);
}
void ParseLabel(const uint32_t *_instruction, IdResult *idResult1)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpLabel);
    uint32_t _o = 1;
    *idResult1  = IdResult(_instruction[_o++]);
}
void ParseBranch(const uint32_t *_instruction, IdRef *targetLabel)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpBranch);
    uint32_t _o  = 1;
    *targetLabel = IdRef(_instruction[_o++]);
}
void ParseBranchConditional(const uint32_t *_instruction,
                            IdRef *condition,
                            IdRef *trueLabel,
                            IdRef *falseLabel,
                            LiteralIntegerList *branchweightsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpBranchConditional);
    uint32_t _o = 1;
    *condition  = IdRef(_instruction[_o++]);
    *trueLabel  = IdRef(_instruction[_o++]);
    *falseLabel = IdRef(_instruction[_o++]);
    if (branchweightsList)
    {
        while (_o < _length)
        {
            branchweightsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseSwitch(const uint32_t *_instruction,
                 IdRef *selector,
                 IdRef *default_,
                 PairLiteralIntegerIdRefList *targetPairList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpSwitch);
    uint32_t _o = 1;
    *selector   = IdRef(_instruction[_o++]);
    *default_   = IdRef(_instruction[_o++]);
    if (targetPairList)
    {
        while (_o < _length)
        {
            targetPairList->emplace_back(PairLiteralIntegerIdRef{LiteralInteger(_instruction[_o]),
                                                                 IdRef(_instruction[_o + 1])});
            _o += 2;
        }
    }
}
void ParseReturnValue(const uint32_t *_instruction, IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpReturnValue);
    uint32_t _o = 1;
    *value      = IdRef(_instruction[_o++]);
}
void ParseImageSparseSampleImplicitLod(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdRef *sampledImage,
                                       IdRef *coordinate,
                                       spv::ImageOperandsMask *imageOperands5,
                                       IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseSampleImplicitLod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    if (imageOperands5 && _o < _length)
    {
        *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSparseSampleExplicitLod(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdRef *sampledImage,
                                       IdRef *coordinate,
                                       spv::ImageOperandsMask *imageOperands5,
                                       IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseSampleExplicitLod);
    uint32_t _o     = 1;
    *idResultType1  = IdResultType(_instruction[_o++]);
    *idResult2      = IdResult(_instruction[_o++]);
    *sampledImage   = IdRef(_instruction[_o++]);
    *coordinate     = IdRef(_instruction[_o++]);
    *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSparseSampleDrefImplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType1,
                                           IdResult *idResult2,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           IdRef *dref,
                                           spv::ImageOperandsMask *imageOperands6,
                                           IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseSampleDrefImplicitLod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    *dref          = IdRef(_instruction[_o++]);
    if (imageOperands6 && _o < _length)
    {
        *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSparseSampleDrefExplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType1,
                                           IdResult *idResult2,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           IdRef *dref,
                                           spv::ImageOperandsMask *imageOperands6,
                                           IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseSampleDrefExplicitLod);
    uint32_t _o     = 1;
    *idResultType1  = IdResultType(_instruction[_o++]);
    *idResult2      = IdResult(_instruction[_o++]);
    *sampledImage   = IdRef(_instruction[_o++]);
    *coordinate     = IdRef(_instruction[_o++]);
    *dref           = IdRef(_instruction[_o++]);
    *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSparseSampleProjImplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType1,
                                           IdResult *idResult2,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           spv::ImageOperandsMask *imageOperands5,
                                           IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseSampleProjImplicitLod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    if (imageOperands5 && _o < _length)
    {
        *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSparseSampleProjExplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType1,
                                           IdResult *idResult2,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           spv::ImageOperandsMask *imageOperands5,
                                           IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseSampleProjExplicitLod);
    uint32_t _o     = 1;
    *idResultType1  = IdResultType(_instruction[_o++]);
    *idResult2      = IdResult(_instruction[_o++]);
    *sampledImage   = IdRef(_instruction[_o++]);
    *coordinate     = IdRef(_instruction[_o++]);
    *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSparseSampleProjDrefImplicitLod(const uint32_t *_instruction,
                                               IdResultType *idResultType1,
                                               IdResult *idResult2,
                                               IdRef *sampledImage,
                                               IdRef *coordinate,
                                               IdRef *dref,
                                               spv::ImageOperandsMask *imageOperands6,
                                               IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseSampleProjDrefImplicitLod);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    *dref          = IdRef(_instruction[_o++]);
    if (imageOperands6 && _o < _length)
    {
        *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSparseSampleProjDrefExplicitLod(const uint32_t *_instruction,
                                               IdResultType *idResultType1,
                                               IdResult *idResult2,
                                               IdRef *sampledImage,
                                               IdRef *coordinate,
                                               IdRef *dref,
                                               spv::ImageOperandsMask *imageOperands6,
                                               IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseSampleProjDrefExplicitLod);
    uint32_t _o     = 1;
    *idResultType1  = IdResultType(_instruction[_o++]);
    *idResult2      = IdResult(_instruction[_o++]);
    *sampledImage   = IdRef(_instruction[_o++]);
    *coordinate     = IdRef(_instruction[_o++]);
    *dref           = IdRef(_instruction[_o++]);
    *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSparseFetch(const uint32_t *_instruction,
                           IdResultType *idResultType1,
                           IdResult *idResult2,
                           IdRef *image,
                           IdRef *coordinate,
                           spv::ImageOperandsMask *imageOperands5,
                           IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseFetch);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *image         = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    if (imageOperands5 && _o < _length)
    {
        *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSparseGather(const uint32_t *_instruction,
                            IdResultType *idResultType1,
                            IdResult *idResult2,
                            IdRef *sampledImage,
                            IdRef *coordinate,
                            IdRef *component,
                            spv::ImageOperandsMask *imageOperands6,
                            IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseGather);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    *component     = IdRef(_instruction[_o++]);
    if (imageOperands6 && _o < _length)
    {
        *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSparseDrefGather(const uint32_t *_instruction,
                                IdResultType *idResultType1,
                                IdResult *idResult2,
                                IdRef *sampledImage,
                                IdRef *coordinate,
                                IdRef *dref,
                                spv::ImageOperandsMask *imageOperands6,
                                IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseDrefGather);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *sampledImage  = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    *dref          = IdRef(_instruction[_o++]);
    if (imageOperands6 && _o < _length)
    {
        *imageOperands6 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseImageSparseTexelsResident(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdRef *residentCode)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseTexelsResident);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *residentCode  = IdRef(_instruction[_o++]);
}
void ParseImageSparseRead(const uint32_t *_instruction,
                          IdResultType *idResultType1,
                          IdResult *idResult2,
                          IdRef *image,
                          IdRef *coordinate,
                          spv::ImageOperandsMask *imageOperands5,
                          IdRefList *imageOperandIdsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpImageSparseRead);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *image         = IdRef(_instruction[_o++]);
    *coordinate    = IdRef(_instruction[_o++]);
    if (imageOperands5 && _o < _length)
    {
        *imageOperands5 = spv::ImageOperandsMask(_instruction[_o++]);
    }
    if (imageOperandIdsList)
    {
        while (_o < _length)
        {
            imageOperandIdsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseModuleProcessed(const uint32_t *_instruction, LiteralString *process)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpModuleProcessed);
    uint32_t _o = 1;
    ASSERT(IsLittleEndian());
    *process = reinterpret_cast<const char *>(&_instruction[_o]);
    _o += strlen(*process) / 4 + 1;
}
void ParseExecutionModeId(const uint32_t *_instruction,
                          IdRef *entryPoint,
                          spv::ExecutionMode *mode,
                          LiteralIntegerList *operandsList)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpExecutionModeId);
    uint32_t _o = 1;
    *entryPoint = IdRef(_instruction[_o++]);
    *mode       = spv::ExecutionMode(_instruction[_o++]);
    if (operandsList)
    {
        while (_o < _length)
        {
            operandsList->emplace_back(_instruction[_o++]);
        }
    }
}
void ParseGroupNonUniformElect(const uint32_t *_instruction,
                               IdResultType *idResultType1,
                               IdResult *idResult2,
                               IdScope *execution)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformElect);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
}
void ParseGroupNonUniformAll(const uint32_t *_instruction,
                             IdResultType *idResultType1,
                             IdResult *idResult2,
                             IdScope *execution,
                             IdRef *predicate)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformAll);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *predicate     = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformAny(const uint32_t *_instruction,
                             IdResultType *idResultType1,
                             IdResult *idResult2,
                             IdScope *execution,
                             IdRef *predicate)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformAny);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *predicate     = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformAllEqual(const uint32_t *_instruction,
                                  IdResultType *idResultType1,
                                  IdResult *idResult2,
                                  IdScope *execution,
                                  IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformAllEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformBroadcast(const uint32_t *_instruction,
                                   IdResultType *idResultType1,
                                   IdResult *idResult2,
                                   IdScope *execution,
                                   IdRef *value,
                                   IdRef *id)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformBroadcast);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    *id            = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformBroadcastFirst(const uint32_t *_instruction,
                                        IdResultType *idResultType1,
                                        IdResult *idResult2,
                                        IdScope *execution,
                                        IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformBroadcastFirst);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformBallot(const uint32_t *_instruction,
                                IdResultType *idResultType1,
                                IdResult *idResult2,
                                IdScope *execution,
                                IdRef *predicate)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformBallot);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *predicate     = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformInverseBallot(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdScope *execution,
                                       IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformInverseBallot);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformBallotBitExtract(const uint32_t *_instruction,
                                          IdResultType *idResultType1,
                                          IdResult *idResult2,
                                          IdScope *execution,
                                          IdRef *value,
                                          IdRef *index)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformBallotBitExtract);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    *index         = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformBallotBitCount(const uint32_t *_instruction,
                                        IdResultType *idResultType1,
                                        IdResult *idResult2,
                                        IdScope *execution,
                                        spv::GroupOperation *operation,
                                        IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformBallotBitCount);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformBallotFindLSB(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdScope *execution,
                                       IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformBallotFindLSB);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformBallotFindMSB(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdScope *execution,
                                       IdRef *value)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformBallotFindMSB);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformShuffle(const uint32_t *_instruction,
                                 IdResultType *idResultType1,
                                 IdResult *idResult2,
                                 IdScope *execution,
                                 IdRef *value,
                                 IdRef *id)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformShuffle);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    *id            = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformShuffleXor(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdScope *execution,
                                    IdRef *value,
                                    IdRef *mask)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformShuffleXor);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    *mask          = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformShuffleUp(const uint32_t *_instruction,
                                   IdResultType *idResultType1,
                                   IdResult *idResult2,
                                   IdScope *execution,
                                   IdRef *value,
                                   IdRef *delta)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformShuffleUp);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    *delta         = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformShuffleDown(const uint32_t *_instruction,
                                     IdResultType *idResultType1,
                                     IdResult *idResult2,
                                     IdScope *execution,
                                     IdRef *value,
                                     IdRef *delta)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformShuffleDown);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    *delta         = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformIAdd(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformIAdd);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformFAdd(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformFAdd);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformIMul(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformIMul);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformFMul(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformFMul);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformSMin(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformSMin);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformUMin(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformUMin);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformFMin(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformFMin);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformSMax(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformSMax);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformUMax(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformUMax);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformFMax(const uint32_t *_instruction,
                              IdResultType *idResultType1,
                              IdResult *idResult2,
                              IdScope *execution,
                              spv::GroupOperation *operation,
                              IdRef *value,
                              IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformFMax);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformBitwiseAnd(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdScope *execution,
                                    spv::GroupOperation *operation,
                                    IdRef *value,
                                    IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformBitwiseAnd);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformBitwiseOr(const uint32_t *_instruction,
                                   IdResultType *idResultType1,
                                   IdResult *idResult2,
                                   IdScope *execution,
                                   spv::GroupOperation *operation,
                                   IdRef *value,
                                   IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformBitwiseOr);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformBitwiseXor(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdScope *execution,
                                    spv::GroupOperation *operation,
                                    IdRef *value,
                                    IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformBitwiseXor);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformLogicalAnd(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdScope *execution,
                                    spv::GroupOperation *operation,
                                    IdRef *value,
                                    IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformLogicalAnd);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformLogicalOr(const uint32_t *_instruction,
                                   IdResultType *idResultType1,
                                   IdResult *idResult2,
                                   IdScope *execution,
                                   spv::GroupOperation *operation,
                                   IdRef *value,
                                   IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformLogicalOr);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformLogicalXor(const uint32_t *_instruction,
                                    IdResultType *idResultType1,
                                    IdResult *idResult2,
                                    IdScope *execution,
                                    spv::GroupOperation *operation,
                                    IdRef *value,
                                    IdRef *clusterSize)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformLogicalXor);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *operation     = spv::GroupOperation(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    if (clusterSize && _o < _length)
    {
        *clusterSize = IdRef(_instruction[_o++]);
    }
}
void ParseGroupNonUniformQuadBroadcast(const uint32_t *_instruction,
                                       IdResultType *idResultType1,
                                       IdResult *idResult2,
                                       IdScope *execution,
                                       IdRef *value,
                                       IdRef *index)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformQuadBroadcast);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    *index         = IdRef(_instruction[_o++]);
}
void ParseGroupNonUniformQuadSwap(const uint32_t *_instruction,
                                  IdResultType *idResultType1,
                                  IdResult *idResult2,
                                  IdScope *execution,
                                  IdRef *value,
                                  IdRef *direction)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpGroupNonUniformQuadSwap);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *execution     = IdScope(_instruction[_o++]);
    *value         = IdRef(_instruction[_o++]);
    *direction     = IdRef(_instruction[_o++]);
}
void ParseCopyLogical(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *operand)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpCopyLogical);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand       = IdRef(_instruction[_o++]);
}
void ParsePtrEqual(const uint32_t *_instruction,
                   IdResultType *idResultType1,
                   IdResult *idResult2,
                   IdRef *operand1,
                   IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpPtrEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}
void ParsePtrNotEqual(const uint32_t *_instruction,
                      IdResultType *idResultType1,
                      IdResult *idResult2,
                      IdRef *operand1,
                      IdRef *operand2)
{
    spv::Op _op;
    uint32_t _length;
    GetInstructionOpAndLength(_instruction, &_op, &_length);
    ASSERT(_op == spv::OpPtrNotEqual);
    uint32_t _o    = 1;
    *idResultType1 = IdResultType(_instruction[_o++]);
    *idResult2     = IdResult(_instruction[_o++]);
    *operand1      = IdRef(_instruction[_o++]);
    *operand2      = IdRef(_instruction[_o++]);
}

}  // namespace spirv
}  // namespace angle
