/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001          */



#include "pthread.h"

#pragma info(none)
#include "pkcsslotd.h"
#include "SlotDB.c"
#pragma info(restore)



/* Header file doesn't use void param lists in prototypes and the compiler is complaining */
extern int             odm_initialize(void);
extern int             odm_terminate(void);
extern int             *odmErrno(void);



#define   ODM_DIRECTORY CONFIG_PATH





/*****************************
 *    Function Prototypes    *
 *****************************/
 
static BOOL            BlankPadNoNull ( char *Dest, char *Src, u_int32 SrcLen );

#ifdef PKCS64
static void            PrintSlotInfo ( Slot_Info_t_64 *P );
#else
static void            PrintSlotInfo ( Slot_Info_t *P );
#endif




#pragma info(none)
#pragma info(restore)

BOOL BooleanVal ( char *ptr, int length, BOOL *result ) {

  int     i;
  char    *p = ptr;

  /* Takes a text-based way of entering Yes/No and converts it to 1 or 0 */
  if ( ptr == NULL ) return FALSE;


  /* skip over leading whitespace */

  i = 0;

  while ( (i < length) && (isspace(ptr[i])) ) {
    i++;
  }

  if ( i >= length ) {
    *result = FALSE;
    return TRUE;
  }

  /* p points to the 1st non-space character */
  p = &(ptr[i]);


  /* Does p start with Y|T|1 (yes, True, 1)? */
  if ( p[0] == 'y' || 
       p[0] == 'Y' ||
       p[0] == 'T' ||
       p[0] == 't' ) {
    *result = TRUE;
    return TRUE;
  }

  /* What about N|F|0 (zero)? */
  if ( p[0] == 'n' || 
       p[0] == 'N' || 
       p[0] == '0' ||
       p[0] == 'F' ||
       p[0] == 'f' ) {
    *result = FALSE;
    return TRUE;
  }

  /* 0 is checked for above.  Any other number is TRUE */
  if ( isdigit( p[0] ) ) {
    *result = TRUE;
    return TRUE;
  }

  /* We've got unrecognized data */

  return FALSE;

}








#ifdef PKCS64
void PrintSlotInfo ( Slot_Info_t_64 *P ) {
#else
void PrintSlotInfo ( Slot_Info_t *P ) {
#endif

#ifdef PKCS64
  CK_SLOT_INFO_64       *ck = NULL;
#else
  CK_SLOT_INFO          *ck = NULL;
#endif

  ck = &(P->pk_slot);

  if (! P->present) return;

  DbgLog(DL3, "slot_number:             %d",      P->slot_number);
  DbgLog(DL3, "present    :             %d",      P->present);
  DbgLog(DL3, "pk_slot    :");
  DbgLog(DL3, "     slotDescription:    '%.64s'", ck->slotDescription);
  DbgLog(DL3, "     manufacturerID :    '%.32s'", ck->manufacturerID);
  DbgLog(DL3, "     flags          :    %#x",     ck->flags);
  DbgLog(DL3, "     hardwareVersion:    %d.%d",   ck->hardwareVersion.major, ck->hardwareVersion.minor);
  DbgLog(DL3, "     firmwareVersion:    %d.%d",   ck->firmwareVersion.major, ck->firmwareVersion.minor);
  DbgLog(DL3, "dll_location:            '%s'",    P->dll_location);
  DbgLog(DL3, "slot_init_fcn:           '%s'",    P->slot_init_fcn);
  DbgLog(DL3, "correlator:              '%s'",    P->correlator);
  DbgLog(DL3, "global_sessions:         %#X",     P->global_sessions);
  DbgLog(DL3, "************************************************");
  return;

}




static BOOL BlankPadNoNull ( char *Dest, char *Src, u_int32 Len ) {

  char *s = NULL;

  /* Allocate Len bytes */
  if ( (s = (char *) malloc(Len)) == NULL ) {
    return FALSE;
  }

  /* Fill with blanks */
  memset(s, ' ', Len);

  /* Copy the string, but not the trailing NULL */
  memcpy(s, Src, ( ( strlen(Src) < Len ) ? strlen(Src) : Len ) );

  /* Copy Len bytes into Dest */
  memcpy(Dest, s, Len);

  /* Free storage */
  free(s);

  return TRUE;

}




BOOL ReadSlotInfoDB ( void ) {

  CLASS_SYMBOL           csSlot;
  char                   *odm_path = NULL;
  struct ck_slot         *p        = NULL;
  struct listinfo        lInfo;
  u_int32                i;
  unsigned char          Index     = 0;
  unsigned char          ValidEntries = 0;
  char                   StartDir[PATH_MAX + 1];

  if ( odm_initialize() != 0 ) {
     ErrLog(SLOTD_MSG(ODMFAIL, 
             "odm_initialize failed (0x%X)\n"), odmerrno);
    return FALSE;
  }


  sprintf(StartDir,"%s",ODM_DIRECTORY);

  if ( (odm_path = odm_set_path(StartDir)) == (char *) -1 ) {
     ErrLog(SLOTD_MSG(ODMSET,
            "Failed to set ODM path (0x%X)"), odmerrno);

    return FALSE;
  }

  DbgLog(DL0, "Set ODM search path from %s to %s", odm_path, StartDir);

  if ( (csSlot = odm_open_class( ck_slot_CLASS  )) < (CLASS_SYMBOL) 0 ) {
    DbgLog(DL0, "ReadSlotInfoDB: odm_open_class() failed; %s (%d; %#x)", ODMConst(odmerrno), odmerrno, odmerrno);
    if ( odm_path != NULL ) { free (odm_path); }
    return FALSE;
  }

  if ( (p = get_ck_slot_list ( csSlot, "", &lInfo, NUMBER_SLOTS_MANAGED, 1) ) == (struct ck_slot *) -1 ) {
    DbgLog (DL0, "ReadSlotInfoDB: get_ck_info_list() failed: %s (%d; %#x)", ODMConst(odmerrno), odmerrno, odmerrno);
    if ( odm_path != NULL ) { free (odm_path); }
    return FALSE;
  }
  
  if ( p == NULL ) {
    DbgLog ( DL0, "ReadSlotInfoDB: get_ck_info_list() returned NULL");
    if ( odm_path != NULL ) { free (odm_path); }
    return FALSE;
  }
  
  DbgLog (DL0, "ReadSlotInfoDB: %d entries found in database", lInfo.num);


  for ( i = 0; i < lInfo.num; i++ ) {
    BOOL                   Res      = FALSE;

#ifdef PKCS64
    CK_SLOT_INFO_64       *pSlot    = NULL;
#else
    CK_SLOT_INFO          *pSlot    = NULL;
#endif


    /* Present */
    /* Set in sinfo[] later, after we've verified Index */

    if ( ! BooleanVal( &(p[i].Present[0]), sizeof(p[i].Present), &Res) ) {
      DbgLog(DL0,"ReadSlotInfoDB: BooleanVal() failed for Present.\n");
      continue;
    }

    if ( ! Res ) {
      /* The database has this slot marked as not present */
      DbgLog(DL2, "ReadSlotInfoDB: Slot '%s' (DB index %d) is marked as not present.  Skipping.", p[i].SlotDescription, i);
      continue;
    }

  


    /* Verify that we've got space to store this entry */

    if ( Index >= NUMBER_SLOTS_MANAGED ) {

      DbgLog(DL0,"ReadSlotInfoDB: Database contains entries for at least %d present slots.  We support %d. Ignoring everything after %d.", 
	      Index + 1, NUMBER_SLOTS_MANAGED, NUMBER_SLOTS_MANAGED );
      break;

    }

    pSlot = &(sinfo[Index].pk_slot);





    /* Check to see that our data structure isn't already in use */

    if ( sinfo[Index].present ) {
      DbgLog (DL0, "ReadSlotInfoDB: Multiple entries in the database for slot # %d.  Exiting.", Index);
      DbgLog ( DL0,"ReadSlotInfoDB: My data structure isn't empty and it should be!");
      if ( odm_path != NULL ) { free (odm_path); }
      if ( p != NULL )        { free (p); }
      return FALSE;
    }

    DbgLog(DL2, "ReadSlotInfoDB: Reading information for slot %d --> %s", Index, p[i].SlotDescription);






    /* SlotNumber */
    /* Warn the user that the SlotNumber field in the DB is depricated */
#ifdef DEV
    if ( p[i].SlotNumber != 0 ) {
      WarnLog("ReadSlotInfoDB: The database contains a SlotNumber entry for a '%s' slot", p[i].SlotDescription );
      WarnLog("ReadSlotInfoDB: The system ignores this value and assigns the slot number dynamically.");
    }
#endif
    sinfo[Index].slot_number = Index;




    /* Present */

    /* No test here because we've already passed it above */
    sinfo[Index].present = (CK_BOOL) TRUE;




    /* Slot Description */
     #pragma info(none)
     if ( ! BlankPadNoNull ( (char *) &(pSlot->slotDescription[0]),
			    &(p[i].SlotDescription[0]), 
			    sizeof(pSlot->slotDescription) ) ) {
     #pragma info(restore)
       ErrLog(SLOTD_MSG(SLOTSKIP, 
              "ReadSlotInfoDB: Error reading SlotDescription '%s'.  Skipping."),
              p[i].SlotDescription);
 
      /* Null out the sinfo struct */
      memset( pSlot, '\0', sizeof(*pSlot) );
      sinfo[Index].present = (CK_BOOL) FALSE;
      continue;
    }





    /* ManufacturerID */
     #pragma info(none)
     if ( ! BlankPadNoNull ( (char *) &(pSlot->manufacturerID[0]), 
			    &(p[i].ManufacturerID[0]), 
			    sizeof(pSlot->manufacturerID) ) ) {
     #pragma info(restore)

      DbgLog(DL0,"ReadSlotInfoDB: Error reading ManufacturerID '%s'.  Skipping.", p[i].ManufacturerID);
      /* Null out the sinfo struct */
      memset( pSlot, '\0', sizeof(*pSlot) );
      sinfo[Index].present = (CK_BOOL) FALSE;
      continue;
    }




    /* TokenPresent */

    if ( ! BooleanVal( &(p[i].TokenPresent[0]), sizeof(p[i].TokenPresent), &Res) ) {
      DbgLog(DL0,"ReadSlotInfoDB: BooleanVal() failed for TokenPresent.\n");
      memset( pSlot, '\0', sizeof(*pSlot) );
      sinfo[Index].present = (CK_BOOL) FALSE;
      continue;
    }

    if ( Res ) { pSlot->flags |= (CKF_TOKEN_PRESENT); }






    /* RemovableToken */

    if ( ! BooleanVal( &(p[i].RemovableToken[0]), sizeof(p[i].RemovableToken), &Res) ) {
      DbgLog(DL0,"ReadSlotInfoDB: BooleanVal() failed for RemovableToken.\n");
      memset( pSlot, '\0', sizeof(*pSlot) );
      sinfo[Index].present = (CK_BOOL) FALSE;
      continue;
    }

    if ( Res ) { pSlot->flags |= (CKF_REMOVABLE_DEVICE); }






    /* HardwareSlot */

    if ( ! BooleanVal( &(p[i].HardwareSlot[0]), sizeof(p[i].HardwareSlot), &Res) ) {
      DbgLog(DL0,"ReadSlotInfoDB: BooleanVal() failed for HardwareSlot.\n");
      memset( pSlot, '\0', sizeof(*pSlot) );
      sinfo[Index].present = (CK_BOOL) FALSE;
      continue;
    }
    if ( Res ) { pSlot->flags |= (CKF_HW_SLOT); } 






    /* HardwareVersion */

    pSlot->hardwareVersion.major = (CK_BYTE) p[i].HwVersionMajor;
    pSlot->hardwareVersion.minor = (CK_BYTE) p[i].HwVersionMinor;





    /* FirmwareVersion */

    pSlot->firmwareVersion.major = (CK_BYTE) p[i].FwVersionMajor;
    pSlot->firmwareVersion.minor = (CK_BYTE) p[i].FwVersionMinor;






    /* DLLLocation */
    {
      struct stat64 statbuf;
      int Err;

      strncpy ( &(sinfo[Index].dll_location[0]), p[i].SlotDll, 
		( (strlen(p[i].SlotDll) > sizeof(sinfo[Index].dll_location)) 
		  ? (sizeof(sinfo[Index].dll_location)) 
		  : (strlen(p[i].SlotDll) ) ) );


      /* Set the last character in the array to NULL since strncpy may mor may not copy the trailing NULL */
      sinfo[Index].dll_location[ sizeof(sinfo[Index].dll_location) - 1] = '\0';

      if ( stat64( sinfo[Index].dll_location, &statbuf ) < 0 ) {
	/* File not found, or other error */
	#pragma info(none)
	  Err = errno;
	#pragma info(restore)

	if ( Err == ENOENT ) {
	  WarnLog ( "***** ReadSlotInfoDB: %s: file not found (%s).  Skipping DB entry.", sinfo[Index].dll_location, SysError(Err) );
	} else {
	  DbgLog (DL0, "***** ReadSlotInfoDB: looking at %s, stat64() returned %s (%d; %#x)", sinfo[Index].dll_location, SysError(Err), Err, Err);
	}
	memset( pSlot, '\0', sizeof(*pSlot) );
	sinfo[Index].present = (CK_BOOL) FALSE;
	continue;
      }

    } /* end DLLLocation unconditional block */






    /* SlotInitFcn */

    /* FIXME: Make sure this is non-NULL */
    strncpy( &(sinfo[Index].slot_init_fcn[0]), &(p[i].SlotInitFcn[0]), 
	     ( strlen(p[i].SlotInitFcn) > sizeof(sinfo[Index].slot_init_fcn) )
	     ? sizeof(sinfo[Index].slot_init_fcn)
	     : strlen(p[i].SlotInitFcn) );

    /* Set the last character in the array to NULL since strncpy may mor may not copy the trailing NULL */
    sinfo[Index].slot_init_fcn[ sizeof(sinfo[Index].slot_init_fcn) - 1 ] = '\0';




    /* Correlator */

    /* FIXME: Make sure this is non-NULL */
    strncpy( &(sinfo[Index].correlator[0]), &(p[i].Correlator[0]), 
	     ( strlen(p[i].Correlator) > sizeof(sinfo[Index].correlator) )
	     ? sizeof(sinfo[Index].correlator)
	     : strlen(p[i].Correlator) );

    /* Set the last character in the array to NULL since strncpy may mor may not copy the trailing NULL */
    sinfo[Index].correlator[ sizeof(sinfo[Index].correlator) - 1 ] = '\0';
    

    

    PrintSlotInfo( &(sinfo[Index]) );

    Index++;

  } /* end for i */

  NumberSlotsInDB = Index;


  if ( p != NULL )        { free(p); }

  /* Do we have a memory leak here? */
  if ( odm_path != NULL ) { 
    odm_set_path(odm_path);
    free (odm_path);
  }

  return TRUE;


}








