/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#include "LRFTypes.h"

namespace libebook
{

LRFBookInfo::LRFBookInfo()
  : author()
  , title()
  , bookID()
  , publisher()
  , label()
  , categories()
  , classification()
  , freeText()
{
}

LRFDocInfo::LRFDocInfo()
  : language()
  , creator()
  , creationDate()
  , producer()
  , page(0)
{
}

LRFMetadata::LRFMetadata()
  : bookInfo()
  , docInfo()
  , keyword()
{
}

LRFColor::LRFColor()
  : r(0)
  , g(0)
  , b(0)
{
}

LRFColor::LRFColor(unsigned color)
  : r((color >> 16) & 0xff)
  , g((color >> 8) & 0xff)
  , b(color & 0xff)
{
}

LRFColor::LRFColor(const unsigned char red, const unsigned char green, const unsigned char blue)
  : r(red)
  , g(green)
  , b(blue)
{
}

LRFAttributes::LRFAttributes()
  : fontSize()
  , fontWidth()
  , fontEscapement()
  , fontOrientation()
  , fontWeight()
  , fontFacename()
  , textColor()
  , textBgColor()
  , wordSpace()
  , letterSpace()
  , baseLineSkip()
  , lineSpace()
  , parIndent()
  , parSkip()
  , height()
  , width()
  , locationX()
  , locationY()
  , italic()
  , sup()
  , sub()
{
}

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */

