/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class ForExpression
extends Assignation {
    private transient RangeVariableDeclaration positionVariable = null;
    private PositionBinding positionBinding = null;

    public void setPositionVariable(RangeVariableDeclaration rangeVariableDeclaration) {
        this.positionVariable = rangeVariableDeclaration;
        this.positionBinding = new PositionBinding();
    }

    public void setAction(Expression expression) {
        super.setAction(expression);
        if (this.positionVariable != null) {
            this.positionVariable.fixupReferences(this.positionBinding);
        }
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        if (this.declaration == null) {
            return this;
        }
        this.sequence = this.sequence.analyze(staticContext);
        SequenceType sequenceType = this.declaration.getRequiredType();
        SequenceType sequenceType2 = new SequenceType(sequenceType.getPrimaryType(), 1792);
        RoleLocator roleLocator = new RoleLocator(3, this.getVariableName(), 0);
        this.sequence = TypeChecker.staticTypeCheck(this.sequence, sequenceType2, false, roleLocator);
        ItemType itemType = this.sequence.getItemType();
        this.declaration.refineTypeInformation(itemType, 512, null, this.sequence.getSpecialProperties());
        this.declaration = null;
        this.action = this.action.analyze(staticContext);
        if (this.positionVariable == null) {
            PromotionOffer promotionOffer = new PromotionOffer();
            promotionOffer.containingExpression = this;
            promotionOffer.action = 11;
            promotionOffer.binding = this;
            this.action = this.action.promote(promotionOffer);
            if (promotionOffer.containingExpression instanceof LetExpression) {
                promotionOffer.containingExpression = promotionOffer.containingExpression.analyze(staticContext);
            }
            return promotionOffer.containingExpression;
        }
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        MappingAction mappingAction = new MappingAction(xPathContext, this.slotNumber, this.positionBinding, this.action);
        return new MappingIterator(sequenceIterator, mappingAction, null, null);
    }

    public ItemType getItemType() {
        return this.action.getItemType();
    }

    public int computeCardinality() {
        int n = this.sequence.getCardinality();
        int n2 = this.action.getCardinality();
        return Cardinality.multiply(n, n2);
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "for $" + this.getVariableName() + (this.positionVariable == null ? "" : " at $?") + " in");
        this.sequence.display(n + 1, namePool);
        System.err.println(ExpressionTool.indent(n) + "return");
        this.action.display(n + 1, namePool);
    }

    private static class PositionBinding
    implements Binding {
        private int position;

        private PositionBinding() {
        }

        private void setPosition(int n) {
            this.position = n;
        }

        public SequenceType getRequiredType() {
            return SequenceType.SINGLE_INTEGER;
        }

        public Value evaluateVariable(XPathContext xPathContext) throws XPathException {
            return new IntegerValue(this.position);
        }

        public String getVariableName() {
            return "zz:at" + this.hashCode();
        }
    }

    private static class MappingAction
    implements MappingFunction {
        private XPathContext context;
        private int slotNumber;
        private Expression action;
        private PositionBinding positionBinding;
        private int position = 1;

        public MappingAction(XPathContext xPathContext, int n, PositionBinding positionBinding, Expression expression) {
            this.context = xPathContext;
            this.slotNumber = n;
            this.positionBinding = positionBinding;
            this.action = expression;
        }

        public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
            this.context.setLocalVariable(this.slotNumber, Value.asValue(item));
            if (this.positionBinding != null) {
                this.positionBinding.setPosition(this.position++);
            }
            return this.action.iterate(this.context);
        }
    }
}

