; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-BE

define <2 x i64> @test2elt(<2 x double> %a) local_unnamed_addr #0 {
; CHECK-P8-LABEL: test2elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xvcvdpuxds v2, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test2elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xvcvdpuxds v2, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test2elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xvcvdpuxds v2, v2
; CHECK-BE-NEXT:    blr
entry:
  %0 = fptoui <2 x double> %a to <2 x i64>
  ret <2 x i64> %0
}

define void @test4elt(<4 x i64>* noalias nocapture sret %agg.result, <4 x double>* nocapture readonly) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test4elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 16
; CHECK-P8-NEXT:    lxvd2x vs1, 0, r4
; CHECK-P8-NEXT:    lxvd2x vs0, r4, r5
; CHECK-P8-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P8-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r5
; CHECK-P8-NEXT:    stxvd2x vs1, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test4elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs0, 16(r4)
; CHECK-P9-NEXT:    lxv vs1, 0(r4)
; CHECK-P9-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P9-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P9-NEXT:    stxv vs0, 16(r3)
; CHECK-P9-NEXT:    stxv vs1, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test4elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs0, 16(r4)
; CHECK-BE-NEXT:    lxv vs1, 0(r4)
; CHECK-BE-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-BE-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-BE-NEXT:    stxv vs0, 16(r3)
; CHECK-BE-NEXT:    stxv vs1, 0(r3)
; CHECK-BE-NEXT:    blr
entry:
  %a = load <4 x double>, <4 x double>* %0, align 32
  %1 = fptoui <4 x double> %a to <4 x i64>
  store <4 x i64> %1, <4 x i64>* %agg.result, align 32
  ret void
}

define void @test8elt(<8 x i64>* noalias nocapture sret %agg.result, <8 x double>* nocapture readonly) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test8elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 16
; CHECK-P8-NEXT:    li r6, 32
; CHECK-P8-NEXT:    li r7, 48
; CHECK-P8-NEXT:    lxvd2x vs3, 0, r4
; CHECK-P8-NEXT:    lxvd2x vs0, r4, r5
; CHECK-P8-NEXT:    lxvd2x vs1, r4, r6
; CHECK-P8-NEXT:    lxvd2x vs2, r4, r7
; CHECK-P8-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-P8-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P8-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P8-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r7
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r6
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r5
; CHECK-P8-NEXT:    stxvd2x vs3, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test8elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs0, 48(r4)
; CHECK-P9-NEXT:    lxv vs1, 32(r4)
; CHECK-P9-NEXT:    lxv vs2, 16(r4)
; CHECK-P9-NEXT:    lxv vs3, 0(r4)
; CHECK-P9-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-P9-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-P9-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P9-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P9-NEXT:    stxv vs0, 48(r3)
; CHECK-P9-NEXT:    stxv vs1, 32(r3)
; CHECK-P9-NEXT:    stxv vs2, 16(r3)
; CHECK-P9-NEXT:    stxv vs3, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test8elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs0, 48(r4)
; CHECK-BE-NEXT:    lxv vs1, 32(r4)
; CHECK-BE-NEXT:    lxv vs2, 16(r4)
; CHECK-BE-NEXT:    lxv vs3, 0(r4)
; CHECK-BE-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-BE-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-BE-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-BE-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-BE-NEXT:    stxv vs0, 48(r3)
; CHECK-BE-NEXT:    stxv vs1, 32(r3)
; CHECK-BE-NEXT:    stxv vs2, 16(r3)
; CHECK-BE-NEXT:    stxv vs3, 0(r3)
; CHECK-BE-NEXT:    blr
entry:
  %a = load <8 x double>, <8 x double>* %0, align 64
  %1 = fptoui <8 x double> %a to <8 x i64>
  store <8 x i64> %1, <8 x i64>* %agg.result, align 64
  ret void
}

define void @test16elt(<16 x i64>* noalias nocapture sret %agg.result, <16 x double>* nocapture readonly) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test16elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 16
; CHECK-P8-NEXT:    li r6, 32
; CHECK-P8-NEXT:    li r7, 64
; CHECK-P8-NEXT:    li r8, 96
; CHECK-P8-NEXT:    li r9, 112
; CHECK-P8-NEXT:    li r10, 80
; CHECK-P8-NEXT:    li r11, 48
; CHECK-P8-NEXT:    lxvd2x vs0, r4, r5
; CHECK-P8-NEXT:    lxvd2x vs1, r4, r6
; CHECK-P8-NEXT:    lxvd2x vs2, r4, r7
; CHECK-P8-NEXT:    lxvd2x vs3, r4, r8
; CHECK-P8-NEXT:    lxvd2x vs4, r4, r9
; CHECK-P8-NEXT:    lxvd2x vs5, r4, r10
; CHECK-P8-NEXT:    lxvd2x vs6, r4, r11
; CHECK-P8-NEXT:    lxvd2x vs7, 0, r4
; CHECK-P8-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P8-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P8-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-P8-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-P8-NEXT:    xvcvdpuxds vs4, vs4
; CHECK-P8-NEXT:    xvcvdpuxds vs5, vs5
; CHECK-P8-NEXT:    xvcvdpuxds vs6, vs6
; CHECK-P8-NEXT:    xvcvdpuxds vs7, vs7
; CHECK-P8-NEXT:    stxvd2x vs4, r3, r9
; CHECK-P8-NEXT:    stxvd2x vs3, r3, r8
; CHECK-P8-NEXT:    stxvd2x vs5, r3, r10
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r7
; CHECK-P8-NEXT:    stxvd2x vs6, r3, r11
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r6
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r5
; CHECK-P8-NEXT:    stxvd2x vs7, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test16elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs0, 112(r4)
; CHECK-P9-NEXT:    lxv vs1, 96(r4)
; CHECK-P9-NEXT:    lxv vs2, 80(r4)
; CHECK-P9-NEXT:    lxv vs3, 64(r4)
; CHECK-P9-NEXT:    lxv vs4, 48(r4)
; CHECK-P9-NEXT:    xvcvdpuxds vs4, vs4
; CHECK-P9-NEXT:    lxv vs5, 32(r4)
; CHECK-P9-NEXT:    lxv vs6, 16(r4)
; CHECK-P9-NEXT:    lxv vs7, 0(r4)
; CHECK-P9-NEXT:    xvcvdpuxds vs7, vs7
; CHECK-P9-NEXT:    xvcvdpuxds vs6, vs6
; CHECK-P9-NEXT:    xvcvdpuxds vs5, vs5
; CHECK-P9-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-P9-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-P9-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P9-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P9-NEXT:    stxv vs0, 112(r3)
; CHECK-P9-NEXT:    stxv vs1, 96(r3)
; CHECK-P9-NEXT:    stxv vs2, 80(r3)
; CHECK-P9-NEXT:    stxv vs3, 64(r3)
; CHECK-P9-NEXT:    stxv vs4, 48(r3)
; CHECK-P9-NEXT:    stxv vs5, 32(r3)
; CHECK-P9-NEXT:    stxv vs6, 16(r3)
; CHECK-P9-NEXT:    stxv vs7, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test16elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs0, 112(r4)
; CHECK-BE-NEXT:    lxv vs1, 96(r4)
; CHECK-BE-NEXT:    lxv vs2, 80(r4)
; CHECK-BE-NEXT:    lxv vs3, 64(r4)
; CHECK-BE-NEXT:    lxv vs4, 48(r4)
; CHECK-BE-NEXT:    xvcvdpuxds vs4, vs4
; CHECK-BE-NEXT:    lxv vs5, 32(r4)
; CHECK-BE-NEXT:    lxv vs6, 16(r4)
; CHECK-BE-NEXT:    lxv vs7, 0(r4)
; CHECK-BE-NEXT:    xvcvdpuxds vs7, vs7
; CHECK-BE-NEXT:    xvcvdpuxds vs6, vs6
; CHECK-BE-NEXT:    xvcvdpuxds vs5, vs5
; CHECK-BE-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-BE-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-BE-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-BE-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-BE-NEXT:    stxv vs0, 112(r3)
; CHECK-BE-NEXT:    stxv vs1, 96(r3)
; CHECK-BE-NEXT:    stxv vs2, 80(r3)
; CHECK-BE-NEXT:    stxv vs3, 64(r3)
; CHECK-BE-NEXT:    stxv vs4, 48(r3)
; CHECK-BE-NEXT:    stxv vs5, 32(r3)
; CHECK-BE-NEXT:    stxv vs6, 16(r3)
; CHECK-BE-NEXT:    stxv vs7, 0(r3)
; CHECK-BE-NEXT:    blr
entry:
  %a = load <16 x double>, <16 x double>* %0, align 128
  %1 = fptoui <16 x double> %a to <16 x i64>
  store <16 x i64> %1, <16 x i64>* %agg.result, align 128
  ret void
}

define <2 x i64> @test2elt_signed(<2 x double> %a) local_unnamed_addr #0 {
; CHECK-P8-LABEL: test2elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xvcvdpsxds v2, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test2elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xvcvdpsxds v2, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test2elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xvcvdpsxds v2, v2
; CHECK-BE-NEXT:    blr
entry:
  %0 = fptosi <2 x double> %a to <2 x i64>
  ret <2 x i64> %0
}

define void @test4elt_signed(<4 x i64>* noalias nocapture sret %agg.result, <4 x double>* nocapture readonly) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test4elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 16
; CHECK-P8-NEXT:    lxvd2x vs1, 0, r4
; CHECK-P8-NEXT:    lxvd2x vs0, r4, r5
; CHECK-P8-NEXT:    xvcvdpsxds vs1, vs1
; CHECK-P8-NEXT:    xvcvdpsxds vs0, vs0
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r5
; CHECK-P8-NEXT:    stxvd2x vs1, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test4elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs0, 16(r4)
; CHECK-P9-NEXT:    lxv vs1, 0(r4)
; CHECK-P9-NEXT:    xvcvdpsxds vs1, vs1
; CHECK-P9-NEXT:    xvcvdpsxds vs0, vs0
; CHECK-P9-NEXT:    stxv vs0, 16(r3)
; CHECK-P9-NEXT:    stxv vs1, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test4elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs0, 16(r4)
; CHECK-BE-NEXT:    lxv vs1, 0(r4)
; CHECK-BE-NEXT:    xvcvdpsxds vs1, vs1
; CHECK-BE-NEXT:    xvcvdpsxds vs0, vs0
; CHECK-BE-NEXT:    stxv vs0, 16(r3)
; CHECK-BE-NEXT:    stxv vs1, 0(r3)
; CHECK-BE-NEXT:    blr
entry:
  %a = load <4 x double>, <4 x double>* %0, align 32
  %1 = fptosi <4 x double> %a to <4 x i64>
  store <4 x i64> %1, <4 x i64>* %agg.result, align 32
  ret void
}

define void @test8elt_signed(<8 x i64>* noalias nocapture sret %agg.result, <8 x double>* nocapture readonly) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test8elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 16
; CHECK-P8-NEXT:    li r6, 32
; CHECK-P8-NEXT:    li r7, 48
; CHECK-P8-NEXT:    lxvd2x vs3, 0, r4
; CHECK-P8-NEXT:    lxvd2x vs0, r4, r5
; CHECK-P8-NEXT:    lxvd2x vs1, r4, r6
; CHECK-P8-NEXT:    lxvd2x vs2, r4, r7
; CHECK-P8-NEXT:    xvcvdpsxds vs3, vs3
; CHECK-P8-NEXT:    xvcvdpsxds vs0, vs0
; CHECK-P8-NEXT:    xvcvdpsxds vs1, vs1
; CHECK-P8-NEXT:    xvcvdpsxds vs2, vs2
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r7
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r6
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r5
; CHECK-P8-NEXT:    stxvd2x vs3, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test8elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs0, 48(r4)
; CHECK-P9-NEXT:    lxv vs1, 32(r4)
; CHECK-P9-NEXT:    lxv vs2, 16(r4)
; CHECK-P9-NEXT:    lxv vs3, 0(r4)
; CHECK-P9-NEXT:    xvcvdpsxds vs3, vs3
; CHECK-P9-NEXT:    xvcvdpsxds vs2, vs2
; CHECK-P9-NEXT:    xvcvdpsxds vs1, vs1
; CHECK-P9-NEXT:    xvcvdpsxds vs0, vs0
; CHECK-P9-NEXT:    stxv vs0, 48(r3)
; CHECK-P9-NEXT:    stxv vs1, 32(r3)
; CHECK-P9-NEXT:    stxv vs2, 16(r3)
; CHECK-P9-NEXT:    stxv vs3, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test8elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs0, 48(r4)
; CHECK-BE-NEXT:    lxv vs1, 32(r4)
; CHECK-BE-NEXT:    lxv vs2, 16(r4)
; CHECK-BE-NEXT:    lxv vs3, 0(r4)
; CHECK-BE-NEXT:    xvcvdpsxds vs3, vs3
; CHECK-BE-NEXT:    xvcvdpsxds vs2, vs2
; CHECK-BE-NEXT:    xvcvdpsxds vs1, vs1
; CHECK-BE-NEXT:    xvcvdpsxds vs0, vs0
; CHECK-BE-NEXT:    stxv vs0, 48(r3)
; CHECK-BE-NEXT:    stxv vs1, 32(r3)
; CHECK-BE-NEXT:    stxv vs2, 16(r3)
; CHECK-BE-NEXT:    stxv vs3, 0(r3)
; CHECK-BE-NEXT:    blr
entry:
  %a = load <8 x double>, <8 x double>* %0, align 64
  %1 = fptosi <8 x double> %a to <8 x i64>
  store <8 x i64> %1, <8 x i64>* %agg.result, align 64
  ret void
}

define void @test16elt_signed(<16 x i64>* noalias nocapture sret %agg.result, <16 x double>* nocapture readonly) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test16elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 16
; CHECK-P8-NEXT:    li r6, 32
; CHECK-P8-NEXT:    li r7, 64
; CHECK-P8-NEXT:    li r8, 96
; CHECK-P8-NEXT:    li r9, 112
; CHECK-P8-NEXT:    li r10, 80
; CHECK-P8-NEXT:    li r11, 48
; CHECK-P8-NEXT:    lxvd2x vs0, r4, r5
; CHECK-P8-NEXT:    lxvd2x vs1, r4, r6
; CHECK-P8-NEXT:    lxvd2x vs2, r4, r7
; CHECK-P8-NEXT:    lxvd2x vs3, r4, r8
; CHECK-P8-NEXT:    lxvd2x vs4, r4, r9
; CHECK-P8-NEXT:    lxvd2x vs5, r4, r10
; CHECK-P8-NEXT:    lxvd2x vs6, r4, r11
; CHECK-P8-NEXT:    lxvd2x vs7, 0, r4
; CHECK-P8-NEXT:    xvcvdpsxds vs0, vs0
; CHECK-P8-NEXT:    xvcvdpsxds vs1, vs1
; CHECK-P8-NEXT:    xvcvdpsxds vs2, vs2
; CHECK-P8-NEXT:    xvcvdpsxds vs3, vs3
; CHECK-P8-NEXT:    xvcvdpsxds vs4, vs4
; CHECK-P8-NEXT:    xvcvdpsxds vs5, vs5
; CHECK-P8-NEXT:    xvcvdpsxds vs6, vs6
; CHECK-P8-NEXT:    xvcvdpsxds vs7, vs7
; CHECK-P8-NEXT:    stxvd2x vs4, r3, r9
; CHECK-P8-NEXT:    stxvd2x vs3, r3, r8
; CHECK-P8-NEXT:    stxvd2x vs5, r3, r10
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r7
; CHECK-P8-NEXT:    stxvd2x vs6, r3, r11
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r6
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r5
; CHECK-P8-NEXT:    stxvd2x vs7, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test16elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs0, 112(r4)
; CHECK-P9-NEXT:    lxv vs1, 96(r4)
; CHECK-P9-NEXT:    lxv vs2, 80(r4)
; CHECK-P9-NEXT:    lxv vs3, 64(r4)
; CHECK-P9-NEXT:    lxv vs4, 48(r4)
; CHECK-P9-NEXT:    xvcvdpsxds vs4, vs4
; CHECK-P9-NEXT:    lxv vs5, 32(r4)
; CHECK-P9-NEXT:    lxv vs6, 16(r4)
; CHECK-P9-NEXT:    lxv vs7, 0(r4)
; CHECK-P9-NEXT:    xvcvdpsxds vs7, vs7
; CHECK-P9-NEXT:    xvcvdpsxds vs6, vs6
; CHECK-P9-NEXT:    xvcvdpsxds vs5, vs5
; CHECK-P9-NEXT:    xvcvdpsxds vs3, vs3
; CHECK-P9-NEXT:    xvcvdpsxds vs2, vs2
; CHECK-P9-NEXT:    xvcvdpsxds vs1, vs1
; CHECK-P9-NEXT:    xvcvdpsxds vs0, vs0
; CHECK-P9-NEXT:    stxv vs0, 112(r3)
; CHECK-P9-NEXT:    stxv vs1, 96(r3)
; CHECK-P9-NEXT:    stxv vs2, 80(r3)
; CHECK-P9-NEXT:    stxv vs3, 64(r3)
; CHECK-P9-NEXT:    stxv vs4, 48(r3)
; CHECK-P9-NEXT:    stxv vs5, 32(r3)
; CHECK-P9-NEXT:    stxv vs6, 16(r3)
; CHECK-P9-NEXT:    stxv vs7, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test16elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs0, 112(r4)
; CHECK-BE-NEXT:    lxv vs1, 96(r4)
; CHECK-BE-NEXT:    lxv vs2, 80(r4)
; CHECK-BE-NEXT:    lxv vs3, 64(r4)
; CHECK-BE-NEXT:    lxv vs4, 48(r4)
; CHECK-BE-NEXT:    xvcvdpsxds vs4, vs4
; CHECK-BE-NEXT:    lxv vs5, 32(r4)
; CHECK-BE-NEXT:    lxv vs6, 16(r4)
; CHECK-BE-NEXT:    lxv vs7, 0(r4)
; CHECK-BE-NEXT:    xvcvdpsxds vs7, vs7
; CHECK-BE-NEXT:    xvcvdpsxds vs6, vs6
; CHECK-BE-NEXT:    xvcvdpsxds vs5, vs5
; CHECK-BE-NEXT:    xvcvdpsxds vs3, vs3
; CHECK-BE-NEXT:    xvcvdpsxds vs2, vs2
; CHECK-BE-NEXT:    xvcvdpsxds vs1, vs1
; CHECK-BE-NEXT:    xvcvdpsxds vs0, vs0
; CHECK-BE-NEXT:    stxv vs0, 112(r3)
; CHECK-BE-NEXT:    stxv vs1, 96(r3)
; CHECK-BE-NEXT:    stxv vs2, 80(r3)
; CHECK-BE-NEXT:    stxv vs3, 64(r3)
; CHECK-BE-NEXT:    stxv vs4, 48(r3)
; CHECK-BE-NEXT:    stxv vs5, 32(r3)
; CHECK-BE-NEXT:    stxv vs6, 16(r3)
; CHECK-BE-NEXT:    stxv vs7, 0(r3)
; CHECK-BE-NEXT:    blr
entry:
  %a = load <16 x double>, <16 x double>* %0, align 128
  %1 = fptosi <16 x double> %a to <16 x i64>
  store <16 x i64> %1, <16 x i64>* %agg.result, align 128
  ret void
}
