#!/usr/bin/perl

# Extract upstream version from version in changelog.

use warnings;
use strict;

use Dpkg::Changelog::Parse;
use Dpkg::Arch qw(get_host_arch);

my $v;

if (get_host_arch() eq "riscv64") {
    $v = '1.14';
} else {
    my $fields = changelog_parse();
    $v = $fields->{Version}->version();
    $v =~ /^([0-9]+\.[0-9]+).*/ or die 'INVALID VERSION! (needs X.Y)';
    $v = $1;
}

printf("%s\n", $v);
